using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class Course : PI.GM.N610.ELearning.BL.DBD.Course
    {
        #region Static factory
        private static Course _factory = null;

        public static new Course DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Course();
                }
                return _factory;
            }
        }
        #endregion

        public enum ExtendedCommands
        {
            CountCourseMaxPointsByDifficulty = 101,
            CountCoursePointsByUser = 102,
            CountCourseExercisesByDifficulty = 103,
            CountCourseExerciseDoneByUser = 104,
            CountCourseExerciseDoneByUserWithMaxPoints = 105,
            CountCourseMaxPointsByUser = 106,
            CountCourseExerciseLoadByUser = 107,
            CountCourseNoStaticExercisesByDifficulty = 108,
            CountCourseExerciseLoadedByUser = 109,
            CountCourseNoStaticExerciseDoneByUser = 110,
        }

        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)ExtendedCommands.CountCourseExerciseDoneByUser: return new ExtendedCommand_CountCourseExerciseDoneByUser();
                case (int)ExtendedCommands.CountCourseExercisesByDifficulty: return new ExtendedCommand_CountCourseExercisesByDifficulty();
                case (int)ExtendedCommands.CountCourseMaxPointsByDifficulty: return new ExtendedCommand_CountCourseMaxPointsByDifficulty();
                case (int)ExtendedCommands.CountCoursePointsByUser: return new ExtendedCommand_CountCoursePointsByUser();
                case (int)ExtendedCommands.CountCourseExerciseDoneByUserWithMaxPoints: return new ExtendedCommand_CountCourseExerciseDoneByUserWithMaxPoints();
                case (int)ExtendedCommands.CountCourseMaxPointsByUser: return new ExtendedCommand_CountCourseMaxPointsByUser();
                case (int)ExtendedCommands.CountCourseExerciseLoadByUser: return new ExtendedCommand_CountCourseExerciseLoadByUser();
                case (int)ExtendedCommands.CountCourseNoStaticExercisesByDifficulty: return new ExtendedCommand_CountCourseNoStaticExercisesByDifficulty();
                case (int)ExtendedCommands.CountCourseExerciseLoadedByUser: return new ExtendedCommand_CountCourseExerciseLoadedByUser();
                case (int)ExtendedCommands.CountCourseNoStaticExerciseDoneByUser: return new ExtendedCommand_CountCourseNoStaticExerciseDoneByUser();
                    

            }
            return base.DoGetCommand(CommandID);
        }

        #region Additional Commands Classes
        class ExtendedCommand_CountCoursePointsByUser : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCoursePointsByUser() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCoursePointsByUser";
            }
        }

        class ExtendedCommand_CountCourseMaxPointsByUser : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCourseMaxPointsByUser() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCourseMaxPointsByUser";
            }
        }

        class ExtendedCommand_CountCourseMaxPointsByDifficulty : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCourseMaxPointsByDifficulty() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCourseMaxPointsByDifficulty";
            }
        }

        class ExtendedCommand_CountCourseExerciseDoneByUser : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCourseExerciseDoneByUser() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCourseExerciseDoneByUser";
            }
        }

        class ExtendedCommand_CountCourseExerciseLoadByUser : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCourseExerciseLoadByUser() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCourseExerciseLoadedByUser";
            }
        }

        class ExtendedCommand_CountCourseExerciseDoneByUserWithMaxPoints : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCourseExerciseDoneByUserWithMaxPoints() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCourseExerciseDoneByUserWithMaxPoints";
            }
        }

        class ExtendedCommand_CountCourseExercisesByDifficulty : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCourseExercisesByDifficulty() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCourseExercisesByDifficulty";
            }
        }

        class ExtendedCommand_CountCourseNoStaticExercisesByDifficulty : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCourseNoStaticExercisesByDifficulty() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCourseNoStaticExercisesByDifficulty";
            }
        }


        class ExtendedCommand_CountCourseExerciseLoadedByUser : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCourseExerciseLoadedByUser() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCourseExerciseLoadedByUser";
            }
        }


        class ExtendedCommand_CountCourseNoStaticExerciseDoneByUser : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountCourseNoStaticExerciseDoneByUser() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Course_CountCourseNoStaticExerciseDoneByUser";
            }
        }
        #endregion
    }
}